﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucAdministration.ascx.cs" Inherits="ucAdministration" %>

<script type="text/javascript">
    
    
    function AriaTreatHideButton(el) {
        el.set({
            "role": 'button'
        });
    }
    function AriaEpiSvBtn(el) {
        el.set({
            "role": 'button'
        });
    }


    function AriaTreatSaveBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaProgCloseBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaAdminNewEpiButton(el) {
        el.set({
            "role": 'button'
        });
    }
    function AriaAdminUpdateEpiButton(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaAdminDelEpiButton(el) {
        el.set({
            "role": 'button'
        });
    }
    function AriaAdminNewProgButton(el) {
        el.set({
            "role": 'button'
        });
    }
    function AriaAdminUpdateProgButton(el) {
        el.set({
            "role": 'button'
        });
    }
    function AriaAdminDelProgButton(el) {
        el.set({
            "role": 'button'
        });
    }
    //grid panel command handlers for buttons in the grid 
    var OnTreatmentCMD = function (command, strStoreRow) {
        switch (command) {
            case "CMD_TREAT_EDIT":
                App.direct.UCADMIN.OnEditTreatment(strStoreRow);
                break;

            case "CMD_TREAT_DEL":
                if (confirm('Are You Sure You Want to Delete this Episode?')) {

                    App.direct.UCADMIN.OnDeleteTreatment(strStoreRow);
                }
                break;
        }
    }

    var OnProgramCMD = function (command, strStoreRow) {
        switch (command) {
            case "CMD_PROG_EDIT":
                App.direct.UCADMIN.OnEditProgram(strStoreRow);
                break;

            case "CMD_PROG_DEL":
                if (confirm('Are You Sure You Want to Delete this Program?')) {

                    App.direct.UCADMIN.OnDeleteProgram(strStoreRow);
                }
                break;
        }
    }

    var fnAdminProgramValForm = function () {
        if (App.dfDlgProgramAdminDate.isValid() && App.dfDlgProgramDischargeDate.isValid()) {
            App.btnTreatSave.setDisabled(false);
        }
        else {
            App.btnTreatSave.setDisabled(true);
        }
    }

    var fnAdminTreatmentValForm = function () {
        if (App.tfDlgTreatmentTitle.isValid() && App.dfDlgTreatmentAdminDate.isValid() && App.dfDlgTreatmentDischargeDate.isValid()) {
            App.btnEpisodeSave.setDisabled(false);
        }
        else {
            App.btnEpisodeSave.setDisabled(true);
        }
    }
</script>

<ext:Window ID="winAdminProgram" 
    runat="server"
    Icon="Information" 
    BodyPadding="6"
    Width="415"
    Height="200" 
    Closable="false"
    Hidden="true" 
    Title="Add Program"
    IDMode="Static"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
        <Show Handler="Ext.defer(function() {App.dfDlgProgramAdminDate.focus(true, 100);}, 1);" />
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
      
    </Listeners>
    <Items>
  
        <ext:Panel ID="PanelucadAP2" Width="390" Border="false" Layout="ColumnLayout" runat="server">
            <Items>
                <ext:Label ID="lblucadAP1" StyleSpec="font-weight:normal;" Text="Initial Date:" runat="server" Padding="3"></ext:Label>
                <ext:DateField ID="dfDlgProgramAdminDate" 
                    runat="server"
                    AllowBlank="false"
                    AutoDataBind="true"
                    Width="100" 
                    MaxDate="<%# DateTime.Today %>"
                    Padding="5"
                    Format="MM/dd/yyyy"
                    Note="MM/DD/YYYY" 
                    NoteAlign="Down"
                    Vtype="date"
                    InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                    <Listeners>
                        <Change Fn="fnAdminTreatmentValForm" />
                    </Listeners>
                </ext:DateField>

                <ext:Label ID="lblucadpm2" StyleSpec="font-weight:normal;" Text="End Date:" runat="server" Padding="3"></ext:Label>
                <ext:DateField ID="dfDlgProgramDischargeDate"
                    runat="server" 
                    AllowBlank="true"
                    AutoDataBind="true" 
                    MaxDate="<%# DateTime.Today %>"
                    Width="100"
                    Padding="5"
                    Format="MM/dd/yyyy"
                    Note="MM/DD/YYYY"
                    NoteAlign="Down"
                    Vtype="date"
                    InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                    <Listeners>
                        <Change Fn="fnAdminTreatmentValForm" />
                    </Listeners>
                </ext:DateField>
            </Items>
        </ext:Panel>

        <ext:Panel ID="pnlucadm3" Width="390" Border="false" Layout="FormLayout" runat="server" Padding="2">
        <Items>
        <ext:ComboBox
            ID="cboDlgProgramCPA"
            runat="server"
            Editable="false"
            ValueField="CPA_ID"
            DisplayField="CPA_TITLE"
            FieldLabel="Clinical Program"
            LabelWidth="100" 
            Padding="0">
            <Store>
                <ext:Store ID="storProgramCPA" AutoLoad="true" runat="server">
                    <Model>
                        <ext:Model ID="mdlProgramCPA" runat="Server" IDProperty="CPA_ID">
                            <Fields>
                                <ext:ModelField Name="CPA_ID" />
                                <ext:ModelField Name="CPA_TITLE" />
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:ComboBox>
        </Items></ext:Panel>
    
    </Items>
    <BottomBar>
    <ext:Toolbar ID="tbucap1" runat="server" >
        <Items>
            <ext:Button ID="btnTreatSave" runat="server" Text="Save" Icon="Disk" >
                <Listeners>
                    <AfterRender Handler="AriaTreatSaveBtn(App.btnTreatSave.getEl());" ></AfterRender>
                </Listeners>
                <DirectEvents>
                    <Click OnEvent="OnSaveProgram">
                    </Click>
                </DirectEvents>
            </ext:Button>

            <ext:Button ID="btnusadm33" runat="server" Text="Cancel" Icon="Cancel" >
                <Listeners>
                    <AfterRender Handler="AriaProgCloseBtn(App.btnusadm33.getEl());" ></AfterRender>
                    <Click Handler="App.winAdminProgram.hide();"></Click>
                </Listeners>
            </ext:Button>
        </Items>
    </ext:Toolbar>
    </BottomBar>
    </ext:Window>

<ext:FormPanel
    runat="server"
    Margin="0"
    Border="false"
    Padding="0" BodyPadding="0"
    PaddingSpec="0 0 0 0"
    Layout="BorderLayout"
    AnchorHorizontal="100%"
    AnchorVertical="100%"
    Flex="1">
    <Items>
        <ext:Panel
            runat="server"
            Margin="0"
            Region="Center"
            Split="true"
            Border="false"
            Layout="FitLayout"
            Flex="1">
            <Items>
                <ext:GridPanel
                    ID="gpTreatments"
                    runat="server"
                    Title="Chronological order of Episodes"
                    Layout="FitLayout"
                    AnchorHorizontal="100%" PaddingSpec="0 0 10 0"
                    AnchorVertical="100%"
                    Border="false">
                 
                    <ColumnModel runat="server">
                        <Columns>

                            <ext:Column runat="server"
                                DataIndex="TREATMENT_TITLE" Text="Episode"
                                Flex="40">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                            </ext:Column>

                            <ext:Column runat="server"
                                DataIndex="TREATMENT_TYPE" Text="Type"
                                Width="103">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                            </ext:Column>

                            <ext:DateColumn runat="server"
                                DataIndex="INITIAL_DATE" Text="Initial Date"
                                Width="100" Format="MM/dd/yyyy" />

                            <ext:DateColumn runat="server"
                                DataIndex="END_DATE" Text="End Date"
                                Width="100" Format="MM/dd/yyyy" />

                        </Columns>
                    </ColumnModel>
                    <Store>
                        <ext:Store ID="storEpisode" AutoLoad="true" runat="server">
                            <Model>
                                <ext:Model runat="Server" IDProperty="TREATMENT_ID">
                                    <Fields>
                                        <ext:ModelField Name="TREATMENT_ID" />
                                        <ext:ModelField Name="TREATMENT_TITLE" />
                                        <ext:ModelField Name="INITIAL_DATE" Type="Date" />
                                        <ext:ModelField Name="END_DATE" Type="Date" />
                                        <ext:ModelField Name="TREATMENT_TYPE_ID" />
                                        <ext:ModelField Name="TREATMENT_TYPE" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>

                    <SelectionModel>
                        <ext:RowSelectionModel runat="server" Mode="Single">
                            <Listeners>
                                <Select Handler="App.direct.UCADMIN.OnTreatmentSelect(Ext.encode(record.data));"></Select>
                            </Listeners>
                            <CustomConfig>
                            </CustomConfig>
                        </ext:RowSelectionModel>
                    </SelectionModel>
                    <BottomBar>
                        <ext:Toolbar ID="tbucadminprog" runat="server" >
                        <Items>

                            <ext:Button ID="btnAdminNewT" runat="server" Text="New Episode" Icon="Add">
                                 <Listeners>
                                    <AfterRender Handler="AriaAdminNewEpiButton(App.btnAdminNewT.getEl());" ></AfterRender>
                                    <Click Handler="App.direct.UCADMIN.OnNewTreatment();"></Click>
                                 </Listeners>
                            </ext:Button>

                            <ext:Button ID="btnUCADMNTreatEdit" runat="server" Text="Update Episode" Icon="Pencil" >
                                <Listeners>
                                    <AfterRender Handler="AriaAdminUpdateEpiButton(App.btnUCADMNTreatEdit.getEl());" ></AfterRender>
                                    <Click Handler="OnTreatmentCMD('CMD_TREAT_EDIT', App.gpTreatments.getSelectionModel().getSelection()[0].data);"></Click>
                                </Listeners>
                            </ext:Button>

                            <ext:Button ID="btnUCADMNTreatDel" runat="server" Text="Delete Episode" Icon="Delete" >
                                <Listeners>
                                    <AfterRender Handler="AriaAdminDelEpiButton(App.btnUCADMNTreatDel.getEl());" ></AfterRender>
                                    <Click Handler="OnTreatmentCMD('CMD_TREAT_DEL', App.gpTreatments.getSelectionModel().getSelection()[0].data);"></Click>
                                </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Toolbar>
                    </BottomBar>
                </ext:GridPanel>
            </Items>
        </ext:Panel>
        <ext:Panel
            runat="server"
            Margin="0"
            Region="South"
            Split="true"
            Border="false"
            Layout="FitLayout" PaddingSpec="0 0 0 0" BodyPadding="0"
            Flex="1">
            <Items>
                <ext:GridPanel
                    ID="gpTreatmentPrograms"
                    runat="server"
                    Title="Chronological List of Clinical Programs"
                    Layout="FitLayout"
                    AnchorHorizontal="100%" PaddingSpec="0 0 0 0"
                    AnchorVertical="100%"
                    Border="false">
                    <Listeners>
                    </Listeners>
                    <SelectionModel>
                        <ext:RowSelectionModel runat="server" Mode="Single">
                            <Listeners>
                               <Select Handler="App.direct.UCADMIN.OnProgramSelect(Ext.encode(record.data));"></Select>
                            </Listeners>
                            <CustomConfig>
                            </CustomConfig>
                        </ext:RowSelectionModel>
                    </SelectionModel>
                    <ColumnModel runat="server">
                        <Columns>

                            <ext:Column runat="server"
                                DataIndex="CPA_TITLE" Text="Program"
                                Flex="40">
                                <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                            </ext:Column>

                            <ext:DateColumn runat="server"
                                DataIndex="INITIAL_DATE" Text="Initial Date"
                                Width="100" Format="MM/dd/yyyy" />


                            <ext:DateColumn runat="server"
                                DataIndex="END_DATE" Text="End Date"
                                Width="100" Format="MM/dd/yyyy" />

                        </Columns>
                    </ColumnModel>
                    <Store>
                        <ext:Store
                            ID="storTreatmentPrograms"
                            AutoLoad="true"
                            runat="server">
                            <Model>
                                <ext:Model ID="mdltreatmentPrograms" runat="Server" IDProperty="PROGRAM_ID">
                                    <Fields>
                                        <ext:ModelField Name="TREATMENT_ID" />
                                        <ext:ModelField Name="PROGRAM_ID" />
                                        <ext:ModelField Name="CPA_ID" />
                                        <ext:ModelField Name="CPA_TITLE" />
                                        <ext:ModelField Name="INITIAL_DATE" Type="Date" />
                                        <ext:ModelField Name="END_DATE" Type="Date" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>

                    <BottomBar>
                        <ext:Toolbar ID="tbucadminprog2" runat="server" >
                        <Items>

                            <ext:Button ID="btnNewProgram" Icon="Add" Disabled="true" Text="New Program" runat="server">
                                <Listeners>
                                    <AfterRender Handler="AriaAdminNewProgButton(App.btnNewProgram.getEl());" ></AfterRender>
                                    <Click Handler="App.direct.UCADMIN.OnNewProgram();"></Click>
                                </Listeners>
                            </ext:Button>

                            <ext:Button ID="btnUCADMNProgEdit" runat="server" Text="Update Program" Icon="Pencil" >
                                <Listeners>
                                    <AfterRender Handler="AriaAdminUpdateProgButton(App.btnUCADMNProgEdit.getEl());" ></AfterRender>
                                    <Click Handler="OnProgramCMD('CMD_PROG_EDIT', App.gpTreatmentPrograms.getSelectionModel().getSelection()[0].data);"></Click>
                                </Listeners>
                            </ext:Button>

                            <ext:Button ID="btnUCADMNProgDel" runat="server" Text="Delete Program" Icon="Delete" >
                                <Listeners>
                                    <AfterRender Handler="AriaAdminDelProgButton(App.btnUCADMNProgDel.getEl());" ></AfterRender>
                                    <Click Handler="OnProgramCMD('CMD_PROG_DEL', App.gpTreatmentPrograms.getSelectionModel().getSelection()[0].data);"></Click>
                                </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Toolbar>
                    </BottomBar>

                </ext:GridPanel>
            </Items>
        </ext:Panel>

    </Items>
</ext:FormPanel>


<ext:Window ID="winAdminTreatment" runat="server"
    Constrain="true"
    ConstrainToElement="pnlMainWorkspace"
    Icon="Information" 
    BodyPadding="6"
    Width="415"
    Height="200" 
    AutoHeight="true"
    Hidden="true" Title="Add Treatment"
    IDMode="Static"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <Listeners>
        <Show Handler="Ext.defer(function() {App.tfDlgTreatmentTitle.focus(true, 100);}, 1);" />
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
    <Items>
                <ext:TextField ID="tfDlgTreatmentTitle" 
                    runat="server"
                    FieldLabel="Title"
                    LabelWidth="45"
                    Width="360"
                    Padding="3"
                    LabelAlign="Left" 
                    Vtype="alphanumXSS">
                    <Listeners>
                        <Change Fn="fnAdminTreatmentValForm" />
                    </Listeners>
                </ext:TextField>

                <ext:Panel Border="false" Layout="ColumnLayout" runat="server" Width="400">
                    <Items>
                        <ext:Label StyleSpec="font-weight:normal;" Text="Initial Date:" runat="server" Padding="3"></ext:Label>
                        <ext:DateField ID="dfDlgTreatmentAdminDate"
                            runat="server"
                            AllowBlank="false" 
                            AutoDataBind="true" MaxDate="<%# DateTime.Today %>"
                            Width="100"
                            Padding="5"
                            Format="MM/dd/yyyy"
                            Note="MM/DD/YYYY"
                            NoteAlign="Down"
                            Vtype="date"
                            InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                            <Listeners>
                                <Change Fn="fnAdminTreatmentValForm" />
                            </Listeners>
                        </ext:DateField>

                        <ext:Label StyleSpec="font-weight:normal;" Text="End Date:" runat="server" Padding="3"></ext:Label>
                        <ext:DateField ID="dfDlgTreatmentDischargeDate"
                            runat="server"
                            AllowBlank="true" 
                            AutoDataBind="true" MaxDate="<%# DateTime.Today %>"
                            Width="100"
                            Padding="5"
                            Format="MM/dd/yyyy"
                            Note="MM/DD/YYYY"
                            NoteAlign="Down"
                            Vtype="date"
                            InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                            <Listeners>
                                <Change Fn="fnAdminTreatmentValForm" />
                            </Listeners>
                        </ext:DateField>
                    </Items>
                </ext:Panel>

                <ext:RadioGroup 
                    runat="server"
                    Vertical="true"
                    Width="250"
                    LabelWidth="50" 
                    Padding="3">
                    <Items>
                        <ext:Radio Width="100" ID="rdoDlgTreatmentInPatient" 
                            BoxLabel="Inpatient" Checked="true" 
                            LabelWidth="40" runat="server"></ext:Radio>
                        <ext:Radio ID="rdoDlgTreatmentOutPatient" 
                            BoxLabel="Outpatient" 
                            LabelWidth="50" runat="server"></ext:Radio>
                    </Items>
                </ext:RadioGroup>

            </Items>
   
    <BottomBar>
        <ext:Toolbar runat="server" >
            <Items>

                <ext:Button ID="btnEpisodeSave" runat="server" Text="Save" Icon="Disk" >
                    <Listeners>
                        <AfterRender Handler="AriaEpiSvBtn(App.btnEpisodeSave.getEl());" ></AfterRender>
                    </Listeners>
                    <DirectEvents>
                        <Click OnEvent="OnSaveTreatment">
                        </Click>
                    </DirectEvents>
                </ext:Button>

                <ext:Button ID="btnTTreatHide" runat="server" Text="Cancel" Icon="Cancel" >
                    <Listeners>
                        <AfterRender Handler="AriaTreatHideButton(App.btnTTreatHide.getEl());" ></AfterRender>
                        <Click Handler="App.winAdminTreatment.hide();"></Click>
                    </Listeners>
                </ext:Button>

            </Items>
        </ext:Toolbar>
    </BottomBar>
</ext:Window>

